package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.adv.direct.banner.resources.OptionalPlatformName
import ru.yandex.adv.direct.banner.resources.PlatformName
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column

@Component
open class BannerMobileContentYtRepository(context: BsExportYtRepositoryContext) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(uint64Column("MobileContentID"), { obj: BannerResources -> obj.mobileContentId }, { v, b -> b.mobileContentId = v!! }),
            mapper(stringColumn("MobileContentBundleID"), { obj: BannerResources -> obj.mobileContentBundleId }, { v, b -> b.mobileContentBundleId = v!! }),
            mapper(uint64Column("MobileContentSource"), { obj: BannerResources -> obj.mobileContentSource.toLong() }, { v, b -> b.mobileContentSource = v!!.toInt() }),
            mapper(stringColumn("MobileContentHref"), { obj: BannerResources -> obj.mobileContentHref }, { v, b -> b.mobileContentHref = v!! }),
            mapper(stringColumn("MobileContentSite"), { obj: BannerResources -> obj.mobileContentSite }, { v, b -> b.mobileContentSite = v!! }),
            mapper(stringColumn("MobileContentSiteFilter"), { obj: BannerResources -> obj.mobileContentSiteFilter }, { v, b -> b.mobileContentSiteFilter = v!! }),
            mapper(stringColumn("MobileContentDomainFilter"), { obj: BannerResources -> obj.mobileContentDomainFilter }, { v, b -> b.mobileContentDomainFilter = v!! }),
            mapper(
                protoColumn("PlatformName", PlatformName::class.java),
                { resources -> if (resources.platformName.hasValue()) resources.platformName.value else null },
                { v, b -> b.platformName = if (v != null) OptionalPlatformName.newBuilder().setValue(v).build() else OptionalPlatformName.newBuilder().build() },
            ))
}
