package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.MulticardSet
import ru.yandex.adv.direct.banner.resources.OptionalMulticardSet
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn

@Component
class BannerMulticardSetYtRepository(
    context: BsExportYtRepositoryContext,
) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(
                protoColumn("MulticardSet", MulticardSet::class.java),
                { resource -> if (resource.multicardSet.hasValue()) resource.multicardSet.value else null },
                { multicardSet, builder -> builder.multicardSet = getOptionalMulticardSet(multicardSet) }
            ),
        )

    fun getOptionalMulticardSet(multicardSet: MulticardSet?): OptionalMulticardSet {
        return if (multicardSet == null) {
            OptionalMulticardSet.newBuilder().build()
        } else {
            OptionalMulticardSet.newBuilder().setValue(multicardSet).build()
        }
    }
}
