package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.UInt64List
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.customColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree
import ru.yandex.inside.yt.kosher.ytree.YTreeNode

@Component
open class BannerPermalinksYtRepository(context: BsExportYtRepositoryContext) : BaseBannerResourcesYtRepository(context) {

    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(stringColumn("PermalinkHref"), { obj -> obj.permalinkHref }, { v, b -> b.permalinkHref = v!! }),
            mapper(stringColumn("PermalinkSite"), { obj -> obj.permalinkSite }, { v, b -> b.permalinkSite = v!! }),
            mapper(stringColumn("PermalinkDomainFilter"), { obj -> obj.permalinkDomainFilter }, { v, b -> b.permalinkDomainFilter = v!! }),
            mapper(uint64Column("PermalinkID"), { obj -> obj.permalinkId }, { v, b -> b.permalinkId = v!! }),
            mapper(stringColumn("PermalinkAssignType"), { obj -> obj.permalinkAssignType }, { v, b -> b.permalinkAssignType = v!! }),
            mapper(customColumn("PermalinkChainIDs"),
                { bannerResources -> writePermalinkChainIds(bannerResources.permalinkChainIds) },
                { v, b -> b.permalinkChainIds = readPermalinkChainIds(v) }
            ))

    private fun writePermalinkChainIds(chainIds: UInt64List): YTreeNode {
        val yTreeListBuilder = YTree.listBuilder()
        chainIds.valuesList
            .forEach { yTreeListBuilder.value(it) }
        return yTreeListBuilder.buildList()
    }

    private fun readPermalinkChainIds(node: YTreeNode?): UInt64List {
        val listBuilder = UInt64List.newBuilder()
        if (node == null) {
            return listBuilder.build()
        }
        node.listNode()
            .map { it.longValue() }
            .forEach { listBuilder.addValues(it) }
        return listBuilder.build()
    }
}
