package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.OptionalPromoExtension
import ru.yandex.adv.direct.banner.resources.PromoExtension
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn

@Component
class BannerPromoExtensionsYtRepository(
    context: BsExportYtRepositoryContext,
) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(
                protoColumn("PromoExtension", PromoExtension::class.java),
                { resource -> if (resource.promoExtension.hasValue()) resource.promoExtension.value else null },
                { promoExtension, builder -> builder.promoExtension = getOptionalPromoExtension(promoExtension) }
            ),
        )

    fun getOptionalPromoExtension(promoExtension: PromoExtension?): OptionalPromoExtension {
        return if (promoExtension == null) {
            OptionalPromoExtension.newBuilder().build()
        } else {
            OptionalPromoExtension.newBuilder().setValue(promoExtension).build()
        }
    }
}
