package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column

@Component
open class BannerTurbolandingYtRepository(context: BsExportYtRepositoryContext) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(uint64Column("TurbolandingID"), { obj -> obj.turbolandingId }, { v, b -> b.turbolandingId = v!! }),
            mapper(stringColumn("TurbolandingHref"), { obj -> obj.turbolandingHref }, { v, b -> b.turbolandingHref = v!! }),
            mapper(stringColumn("TurbolandingSite"), { obj -> obj.turbolandingSite }, { v, b -> b.turbolandingSite = v!! }),
            mapper(stringColumn("TurbolandingDomainFilter"), { obj -> obj.turbolandingDomainFilter }, { v, b -> b.turbolandingDomainFilter = v!! }),
        )
}
