package ru.yandex.direct.bstransport.yt.repository.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.MetrikaSnippet
import ru.yandex.adv.direct.banner.resources.OptionalMetrikaSnippet
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.protoColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn

@Component
class BannerZenSubscribeYtRepository(
    context: BsExportYtRepositoryContext
) : BaseBannerResourcesYtRepository(context) {
    override val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
        get() = listOf(
            mapper(stringColumn("PublisherItemId"),
                { resource -> resource.publisherItemId },
                { value, builder -> value?.let { builder.publisherItemId = value }}),

            mapper(protoColumn("MetrikaSnippet", MetrikaSnippet::class.java),
                { resource -> if (resource.metrikaSnippet.hasValue()) resource.metrikaSnippet.value else null },
                { metrikaSnippet, builder ->
                    metrikaSnippet?.let {
                        builder.metrikaSnippet = OptionalMetrikaSnippet.newBuilder().setValue(it).build() }
                        ?: run { builder.metrikaSnippet = OptionalMetrikaSnippet.newBuilder().build() }})
        )
}
