package ru.yandex.direct.bstransport.yt.repository.resources

import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.int64Column
import ru.yandex.direct.bstransport.yt.repository.uint64Column
import ru.yandex.yt.ytclient.tables.ColumnSortOrder
import java.time.Instant

abstract class BaseBannerResourcesYtRepository(context: BsExportYtRepositoryContext)
    : BaseBsExportYtRepository<BannerResources>(context, context.ytConfig.bannerResourcesTable, context.ytConfig.bannerResourcesQueue) {

    abstract val resourceColumnSchema: List<BannerResourcesColumnMapping<out Any>>
    override fun getSchemaWithMapping(): List<BannerResourcesColumnMapping<out Any>> {
        val keysSchemaMappers = listOf(
            mapper(int64Column("OrderID", ColumnSortOrder.ASCENDING), { obj -> obj.orderId }, { value, builder -> builder.orderId = value!! }),
            mapper(int64Column("BannerID", ColumnSortOrder.ASCENDING), { obj -> obj.bannerId }, { value, builder -> builder.bannerId = value!! }),
            mapper(uint64Column("ExportID"), { obj -> obj.exportId }, { v, b -> if (v != null) b.exportId = v }),
            mapper(uint64Column("AdGroupID"), { obj -> obj.adgroupId }, { v, b -> if (v != null) b.adgroupId = v }),
            mapper(uint64Column("UpdateTime"), { obj -> obj.updateTime }, { v, b ->
                b.updateTime = v ?: Instant.now().epochSecond
            }),
            mapper(uint64Column("IterID"), { obj -> obj.iterId }, { v, b -> b.iterId = v ?: 0L })
        )
        val mappers = mutableListOf<BannerResourcesColumnMapping<out Any>>()
        mappers.addAll(keysSchemaMappers)
        mappers.addAll(resourceColumnSchema)
        return mappers
    }

    override fun delete(rows: Collection<BannerResources>) {
        throw IllegalStateException("Delete operation not supported for banner resources")
    }
}
