package ru.yandex.direct.bstransport.yt.repository.showconditions;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.adv.direct.showcondition.DynamicConditionData;
import ru.yandex.adv.direct.showcondition.FeedFilterData;
import ru.yandex.adv.direct.showcondition.KeywordData;
import ru.yandex.adv.direct.showcondition.RelevanceMatchData;
import ru.yandex.adv.direct.showcondition.RetargetingData;
import ru.yandex.adv.direct.showconditions.BiddableShowCondition;
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository;
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext;
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping;
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeProtoUtils;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeListNode;

import static ru.yandex.direct.bstransport.yt.repository.ColumnDescriptionKt.boolColumn;
import static ru.yandex.direct.bstransport.yt.repository.ColumnDescriptionKt.customColumn;
import static ru.yandex.direct.bstransport.yt.repository.ColumnDescriptionKt.int64Column;
import static ru.yandex.direct.bstransport.yt.repository.ColumnDescriptionKt.protoColumn;
import static ru.yandex.direct.bstransport.yt.repository.ColumnDescriptionKt.uint64Column;
import static ru.yandex.direct.bstransport.yt.repository.ColumnMapping.column;
import static ru.yandex.yt.ytclient.tables.ColumnSortOrder.ASCENDING;

@Component
public class BiddableShowConditionYtRepository extends BaseBsExportYtRepository<BiddableShowCondition> {
    public BiddableShowConditionYtRepository(BsExportYtRepositoryContext context) {
        super(context, context.getYtConfig().getBiddableShowConditionsTable(),
                context.getYtConfig().getBiddableShowConditionsQueue());
    }

    @Override
    public List<ColumnMapping<BiddableShowCondition>> getSchemaWithMapping() {
        return List.of(
                new ColumnMapping<>(uint64Column("OrderID", ASCENDING),
                        BiddableShowCondition::getOrderId),
                new ColumnMapping<>(uint64Column("AdGroupID", null),
                        BiddableShowCondition::getAdGroupId),
                new ColumnMapping<>(uint64Column("ContextType", null),
                        BiddableShowCondition::getContextType),
                new ColumnMapping<>(uint64Column("Id", null),
                        BiddableShowCondition::getId),

                column(int64Column("Bid", null), BiddableShowCondition::getBid),
                column(int64Column("BidContext", null), BiddableShowCondition::getBidContext),

                column(protoColumn("KeywordData", KeywordData.class, null),
                        b -> b.hasKeywordData() ? b.getKeywordData() : null),

                column(protoColumn("DynamicConditionData", DynamicConditionData.class, null),
                        b -> b.hasDynamicConditionData() ? b.getDynamicConditionData() : null),

                column(protoColumn("RelevanceMatchData", RelevanceMatchData.class, null),
                        b -> b.hasRelevanceMatchData() ? b.getRelevanceMatchData() : null),

                column(protoColumn("FeedFilterData", FeedFilterData.class, null),
                        b -> b.hasFeedFilterData() ? b.getFeedFilterData() : null),

                column(protoColumn("RetargetingData", RetargetingData.class, null),
                        b -> b.hasRetargetingData() ? b.getRetargetingData() : null),

                column(customColumn("HrefParams", null), this::hrefParamsToYt),

                column(boolColumn("Suspended", null), BiddableShowCondition::getSuspended),

                column(uint64Column("IterID", null), BiddableShowCondition::getIterId),
                column(uint64Column("DeleteTime", null), BiddableShowCondition::getDeleteTime),
                column(uint64Column("UpdateTime", null), BiddableShowCondition::getUpdateTime)
        );
    }

    private YTreeListNode hrefParamsToYt(BiddableShowCondition b) {
        var builder = YTree.listBuilder();
        for (var message : b.getHrefParamsList()) {
            var param = YTreeProtoUtils.marshal(message);
            builder.value(param);
        }
        return builder.buildList();
    }
}
