package ru.yandex.direct.bstransport.yt.repository.strategy

import javax.annotation.ParametersAreNonnullByDefault
import ru.yandex.adv.direct.strategy.Strategy
import ru.yandex.direct.bstransport.yt.repository.BaseBsExportYtRepository
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.ColumnDescription
import ru.yandex.direct.bstransport.yt.repository.ColumnMapping
import ru.yandex.direct.bstransport.yt.repository.uint64Column
import ru.yandex.yt.ytclient.tables.ColumnSortOrder

@ParametersAreNonnullByDefault
abstract class BaseStrategyYtRepository(
    context: BsExportYtRepositoryContext
) : BaseBsExportYtRepository<Strategy>(context, context.ytConfig.strategiesTable, context.ytConfig.strategiesQueue) {
    abstract fun getNonKeysColumnSchema(): List<ColumnMapping<Strategy>>

    override fun getSchemaWithMapping(): List<ColumnMapping<Strategy>> {
        val keysSchema = columnSchemaOf(
            Strategy::getStrategyId to uint64Column("StrategyID", sortOrder = ColumnSortOrder.ASCENDING)
        )
        return keysSchema + getNonKeysColumnSchema()
    }

    override fun delete(rows: Collection<Strategy>) {
        throw IllegalStateException("Delete operation not supported for strategies")
    }

    protected fun columnSchemaOf(vararg mappers: Pair<(Strategy) -> Any?, ColumnDescription<*>>) =
        mappers.map { (mapper, columnDescription) -> ColumnMapping.column(columnDescription, mapper) }
}
