package ru.yandex.direct.bstransport.yt.repository.strategy

import org.springframework.stereotype.Repository
import ru.yandex.adv.direct.strategy.AttributionModel
import ru.yandex.adv.direct.strategy.DayBudgetShowMode
import ru.yandex.adv.direct.strategy.Strategy
import ru.yandex.adv.direct.strategy.StrategyType
import ru.yandex.direct.bstransport.yt.repository.BsExportYtRepositoryContext
import ru.yandex.direct.bstransport.yt.repository.boolColumn
import ru.yandex.direct.bstransport.yt.repository.customColumn
import ru.yandex.direct.bstransport.yt.repository.stringColumn
import ru.yandex.direct.bstransport.yt.repository.uint64Column

@Repository
class StrategyYtRepository(context: BsExportYtRepositoryContext) : BaseStrategyYtRepository(context) {

    override fun getNonKeysColumnSchema() = columnSchemaOf(
        CLIENT_ID_GETTER to uint64Column("ClientID"),
        AGENCY_ID_GETTER to uint64Column("AgencyID"),
        TYPE_GETTER to stringColumn("Type"),
        ATTRIBUTION_MODEL_GETTER to stringColumn("AttributionModel"),
        DAY_BUDGET_GETTER to uint64Column("DayBudget"),
        DAY_BUDGET_SHOW_MODE_GETTER to stringColumn("DayBudgetShowMode"),
        WALLET_ID_GETTER to uint64Column("WalletExportID"),
        IS_ARCHIVED_GETTER to boolColumn("IsArchived"),
        MEANINGFUL_GOALS_GETTER to customColumn("MeaningfulGoals"),
        METRIKA_COUNTER_IDS_GETTER to customColumn("MetrikaCounterIDs"),
        AVG_CPA_GETTER to uint64Column("AvgCpa"),
        AVG_BID_GETTER to uint64Column("AvgBid"),
        CRR_GETTER to uint64Column("Crr"),
        ROI_GETTER to uint64Column("RoiCoef"),
        PROFITABILITY_GETTER to uint64Column("Profitability"),
        RESERVE_GETTER to uint64Column("ReserveReturn"),
        BID_GETTER to uint64Column("Bid"),
        AVG_CPM_GETTER to uint64Column("AvgCpm"),
        AVG_CPV_GETTER to uint64Column("AvgCpv"),
        GOAL_ID_GETTER to uint64Column("GoalID"),
        CUSTOM_PERIOD_BUDGET_GETTER to uint64Column("CustomPeriodBudget"),
        START_GETTER to uint64Column("Start"),
        FINISH_GETTER to uint64Column("Finish"),
        AUTO_PROLONGATION_GETTER to boolColumn("AutoProlongation"),
        PAY_FOR_CONVERSION_GETTER to boolColumn("PayForConversion"),
        WEEK_BUDGET_GETTER to uint64Column("WeekBudget"),
        LIMIT_CLICKS_GETTER to uint64Column("LimitClicks"),
        CURRENCY_ID_GETTER to uint64Column("CurrencyID"),
        NDS_HISTORY_GETTER to customColumn("NDSHistory"),
        WALLET_ORDER_ID_GETTER to uint64Column("WalletOrderID"),
        GENERAL_INITIAL_AUCTION_PROBABILITY to uint64Column("GeneralInitialAuctionProbability")
    )

    companion object {
        private val CLIENT_ID_GETTER = optionalMapping(Strategy::hasClientId, Strategy::getClientId)
        private val AGENCY_ID_GETTER = optionalMapping(Strategy::hasAgencyId, Strategy::getAgencyId)
        private val TYPE_GETTER = optionalMapping(Strategy::hasType) { StrategyType.forNumber(it.type).name }
        private val ATTRIBUTION_MODEL_GETTER = optionalMapping(Strategy::hasAttributionModel) { AttributionModel.forNumber(it.attributionModel).name }
        private val DAY_BUDGET_GETTER = optionalMapping(Strategy::hasDayBudget, Strategy::getDayBudget)
        private val DAY_BUDGET_SHOW_MODE_GETTER = optionalMapping(Strategy::hasDayBudgetShowMode) {
            DayBudgetShowMode.forNumber(
                it.dayBudgetShowMode
            ).name
        }
        private val WALLET_ID_GETTER = optionalMapping(Strategy::hasWalletExportId, Strategy::getWalletExportId)
        private val IS_ARCHIVED_GETTER = optionalMapping(Strategy::hasIsArchived, Strategy::getIsArchived)
        private val MEANINGFUL_GOALS_GETTER = optionalMapping(Strategy::hasMeaningfulGoals, Strategy::getMeaningfulGoals)
        private val METRIKA_COUNTER_IDS_GETTER = optionalMapping({ it.metrikaCounterIdsList != null}, Strategy::getMetrikaCounterIdsList)
        private val AVG_CPA_GETTER = optionalMapping(Strategy::hasAvgCpa, Strategy::getAvgCpa)
        private val AVG_BID_GETTER = optionalMapping(Strategy::hasAvgBid, Strategy::getAvgBid)
        private val CRR_GETTER = optionalMapping(Strategy::hasCrr, Strategy::getCrr)
        private val ROI_GETTER = optionalMapping(Strategy::hasRoiCoef, Strategy::getRoiCoef)
        private val PROFITABILITY_GETTER = optionalMapping(Strategy::hasProfitability, Strategy::getProfitability)
        private val RESERVE_GETTER = optionalMapping(Strategy::hasReserveReturn, Strategy::getReserveReturn)
        private val BID_GETTER = optionalMapping(Strategy::hasBid, Strategy::getBid)
        private val AVG_CPM_GETTER = optionalMapping(Strategy::hasAvgCpm, Strategy::getAvgCpm)
        private val AVG_CPV_GETTER = optionalMapping(Strategy::hasAvgCpv, Strategy::getAvgCpv)
        private val GOAL_ID_GETTER = optionalMapping(Strategy::hasGoalId, Strategy::getGoalId)
        private val CUSTOM_PERIOD_BUDGET_GETTER = optionalMapping(Strategy::hasCustomPeriodBudget, Strategy::getCustomPeriodBudget)
        private val START_GETTER = optionalMapping(Strategy::hasStart, Strategy::getStart)
        private val FINISH_GETTER = optionalMapping(Strategy::hasFinish, Strategy::getFinish)
        private val AUTO_PROLONGATION_GETTER = optionalMapping(Strategy::hasAutoProlongation, Strategy::getAutoProlongation)
        private val PAY_FOR_CONVERSION_GETTER = optionalMapping(Strategy::hasPayForConversion, Strategy::getPayForConversion)
        private val WEEK_BUDGET_GETTER = optionalMapping(Strategy::hasWeekBudget, Strategy::getWeekBudget)
        private val LIMIT_CLICKS_GETTER = optionalMapping(Strategy::hasLimitClicks, Strategy::getLimitClicks)
        private val CURRENCY_ID_GETTER = optionalMapping(Strategy::hasCurrencyId, Strategy::getCurrencyId)
        private val NDS_HISTORY_GETTER = optionalMapping(Strategy::hasNdsHistory, Strategy::getNdsHistory)
        private val WALLET_ORDER_ID_GETTER = optionalMapping(Strategy::hasWalletOrderId, Strategy::getWalletOrderId)
        private val GENERAL_INITIAL_AUCTION_PROBABILITY = optionalMapping(Strategy::hasGeneralInitialAuctionProbability,
            Strategy::getGeneralInitialAuctionProbability)
    }
}

private inline fun <T> optionalMapping(
    crossinline predicate: (T) -> Boolean,
    crossinline mapping: (T) -> Any?,
): (T) -> Any? = { it.takeIf(predicate)?.run(mapping) }
