package ru.yandex.direct.bstransport.yt.service

import com.google.protobuf.Message
import ru.yandex.direct.bstransport.yt.repository.common.RowPosition

data class ObjectsWithPosition<T1, T2>(
    val objects: List<T1>,
    val position: T2
)

data class YtHashBorders(
    val first: Long,
    val second: Long,
    val isAbsent: Boolean = false
)

/**
 * Базовый класс для перекладывания строк из таблиц единой базы в очередь Caesar
 * T1 - тип объекта, который кладется в очередь
 * T2 - класс, хранящий позицию строки в таблице(значения ключей)
 */
abstract class BaseTableToQueueResyncService<T1 : Message, T2 : RowPosition> {

    /**
     * Получить максимально возможное значение поля YtHash
     */
    abstract fun getYtHashMaxValue(): Long

    /**
     * Переложить объекты из таблицы в очередь и вернуть переложенные объекты с соответствующим полем ytHash
     */
    abstract fun resyncObjects(position: T2, limit: Int, maxYtHash: Long): ObjectsWithPosition<T1, T2>

    fun getYtHashBorders(bucketNumber: Int, bucketsCnt: Int): YtHashBorders {
        val ytHashMaxValue = getYtHashMaxValue()
        val batchSize = ((ytHashMaxValue + bucketsCnt) / bucketsCnt).toInt()
        val ytHashRanges = (0..ytHashMaxValue).chunked(batchSize)
        return if (bucketNumber >= ytHashRanges.size) YtHashBorders(-1, -1, true)
        else YtHashBorders(ytHashRanges[bucketNumber].first(), ytHashRanges[bucketNumber].last())
    }
}
