package ru.yandex.direct.bstransport.yt.service.adgroups

import com.google.protobuf.Message
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupCommonYtRepository
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupsPosition
import ru.yandex.direct.bstransport.yt.service.BaseTableToQueueResyncService
import ru.yandex.direct.bstransport.yt.service.ObjectsWithPosition
import ru.yandex.direct.tracing.Trace

abstract class BaseAdGroupsTableToQueueResyncService<T1 : Message>(
    private val ytRepository: AdGroupCommonYtRepository<T1>
) : BaseTableToQueueResyncService<T1, AdGroupsPosition>() {

    abstract val traceFunc: String
    abstract fun getAdGroupId(obj: T1): Long
    override fun resyncObjects(position: AdGroupsPosition, limit: Int, maxYtHash: Long): ObjectsWithPosition<T1, AdGroupsPosition> {
        val adGroupsWithYtHash = Trace.current().profile("$traceFunc:yt").use {
            ytRepository.getAdGroupsForResync(position, limit, maxYtHash)
        }
        if (adGroupsWithYtHash.isEmpty()) {
            return ObjectsWithPosition(listOf(), position)
        }
        val nextYtHash = adGroupsWithYtHash
            .maxOf { it.ytHash }

        val nextAdGroupId = adGroupsWithYtHash.asSequence()
            .filter { it.ytHash == nextYtHash }
            .maxOf { getAdGroupId(it.adGroup) }

        val adGroupsList = adGroupsWithYtHash.map { it.adGroup }
        Trace.current().profile("$traceFunc:yt").use {
            ytRepository.writeToQueue(adGroupsList)
        }
        val nextPosition = AdGroupsPosition(nextYtHash, nextAdGroupId)
        return ObjectsWithPosition(adGroupsList, nextPosition)
    }

    override fun getYtHashMaxValue() = ytRepository.getYtHashMaxValue()
}
