package ru.yandex.direct.bstransport.yt.service.resources

import org.springframework.stereotype.Service
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.BannerResourcesYtCommonRepository
import ru.yandex.direct.bstransport.yt.repository.resources.ResourcesPosition
import ru.yandex.direct.bstransport.yt.service.BaseTableToQueueResyncService
import ru.yandex.direct.bstransport.yt.service.ObjectsWithPosition
import ru.yandex.direct.tracing.Trace


@Service
class BannerResourcesTableToQueueResyncService(
    private val bannerResourcesYtRepository: BannerResourcesYtCommonRepository
) : BaseTableToQueueResyncService<BannerResources, ResourcesPosition>() {

    override fun resyncObjects(resourcesPosition: ResourcesPosition, limit: Int, maxYtHash: Long): ObjectsWithPosition<BannerResources, ResourcesPosition> {
        val resourcesWithYtHash = Trace.current().profile("read_resources:yt").use {
            bannerResourcesYtRepository.getBannerResourcesForResync(resourcesPosition, limit, maxYtHash)
        }
        if (resourcesWithYtHash.isEmpty()) {
            return ObjectsWithPosition(listOf(), resourcesPosition)
        }
        val nextYtHash = resourcesWithYtHash
            .maxOf { it.ytHash }

        val nextOrderId = resourcesWithYtHash.asSequence()
            .filter { it.ytHash == nextYtHash }
            .maxOf { it.resources.orderId }

        val nextBannerId = resourcesWithYtHash.asSequence()
            .filter { it.ytHash == nextYtHash && it.resources.orderId == nextOrderId }
            .maxOf { it.resources.bannerId }

        val resourcesList = resourcesWithYtHash.map { it.resources }
        Trace.current().profile("write_resources:yt").use {
            bannerResourcesYtRepository.writeBannerResourcesToQueue(resourcesList)
        }
        val position = ResourcesPosition(nextYtHash, nextOrderId, nextBannerId)
        return ObjectsWithPosition(resourcesList, position)
    }

    override fun getYtHashMaxValue() = bannerResourcesYtRepository.getYtHashMaxValue()
}
