package ru.yandex.direct.bstransport.yt.utils

import com.google.protobuf.Message
import ru.yandex.inside.yt.kosher.impl.ytree.YTreeProtoUtils
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree
import ru.yandex.inside.yt.kosher.ytree.YTreeNode

object ColumnMappingUtils {

    fun writeStringList(list: List<String>): YTreeNode {
        val yTreeListBuilder = YTree.listBuilder()
        list
            .forEach { yTreeListBuilder.value(it) }
        return yTreeListBuilder.buildList()
    }

    fun readStringList(node: YTreeNode?): List<String> {
        if (node == null) {
            return listOf()
        }
        return node.listNode()
            .map { it.stringValue() }
    }

    inline fun <reified T : Message> writeProtoList(messages: List<T>): YTreeNode {
        val builder = YTree.listBuilder()
        for (message in messages) {
            val proto = YTreeProtoUtils.marshal(message)
            builder.value(proto)
        }
        return builder.buildList()
    }

    inline fun <reified T : Message> readProtoList(node: YTreeNode?): List<T> {
        if (node == null) {
            return listOf()
        }
        return node.listNode()
            .map { YTreeProtoUtils.unmarshal(it, T::class.java) }
    }
}
