package ru.yandex.direct.bstransport.yt.utils

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignTypeKinds
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.currency.Money
import ru.yandex.direct.currency.Percent
import java.math.BigDecimal
import java.math.MathContext
import java.math.MathContext.DECIMAL64
import java.math.RoundingMode

object ToBsConversionUtils {
    val MILLION = BigDecimal(1_000_000)
    val NDS_CALCULATION_SCALE = 6
    var CPM_SHOWS_COEF = BigDecimal(1000)
    val ROUND_UP = MathContext(DECIMAL64.precision, RoundingMode.HALF_UP)

    @JvmStatic
    fun bsPreparePrice(value: BigDecimal, currency: Currency, campaignType: CampaignType): Int {
        // округляем до шага торгов
        var ret = Money.valueOf(value, currency.code)
            .roundToAuctionStepDown()
            .bigDecimalValue()
        // обрезаем до максимальной цены
        if (ret > currency.maxPrice) {
            ret = currency.maxPrice
        }
        // для cpm-кампаний - цена для 1000 показов, приводим
        if (campaignType in CampaignTypeKinds.CPM) {
            ret = ret.divide(CPM_SHOWS_COEF)
        }
        // приводим к целочисленному виду с скейлом БК
        return ret
            .multiply(MILLION)
            .divide(currency.yabsRatio.toBigDecimal())
            .setScale(0, RoundingMode.HALF_UP)
            .toInt()
    }

    @JvmStatic
    fun bsMoneyForPerformance(value: BigDecimal?, campValue: BigDecimal?, currency: Currency, nds: Percent?): Int {
        var effValue =
            if (value != null && value > BigDecimal.ZERO) value
            else campValue ?: BigDecimal.ZERO

        if (effValue <= BigDecimal.ZERO) {
            return 0
        }

        effValue = effValue.setScale(NDS_CALCULATION_SCALE)

        if (nds != null && nds.asPercent() > BigDecimal.ZERO) {
            effValue = effValue.multiply(BigDecimal.ONE.plus(nds.asRatio()))
        }

        return effValue
            .multiply(MILLION)
            .divide(currency.yabsRatio.toBigDecimal())
            .toInt()
    }
}
