package ru.yandex.direct.bsexport;

import java.util.ArrayList;
import java.util.List;

public class BsProcessedResponse {
    private final List<Long> undoneCampaigns;
    private final List<Long> errorCampaigns;
    private final List<Long> processedCampaigns;
    private final List<Long> absentCampaigns;

    public BsProcessedResponse() {
        this.undoneCampaigns = new ArrayList<>();
        this.errorCampaigns = new ArrayList<>();
        this.processedCampaigns = new ArrayList<>();
        this.absentCampaigns = new ArrayList<>();
    }

    public List<Long> getUndoneCampaigns() {
        return undoneCampaigns;
    }

    public List<Long> getErrorCampaigns() {
        return errorCampaigns;
    }

    public List<Long> getProcessedCampaigns() {
        return processedCampaigns;
    }

    public List<Long> getAbsentCampaigns() {
        return absentCampaigns;
    }

    public void addUndoneCampaign(Long undoneCampaign) {
        this.undoneCampaigns.add(undoneCampaign);
    }

    public void addErrorCampaign(Long errorCampaign) {
        this.errorCampaigns.add(errorCampaign);
    }

    public void addProcessedCampaign(Long processedCampaign) {
        this.processedCampaigns.add(processedCampaign);
    }

    public void addAbsentCampaign(Long missedCampaign) {
        this.absentCampaigns.add(missedCampaign);
    }
}
