package ru.yandex.direct.bsexport;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.bsexport.model.Order;
import ru.yandex.direct.bsexport.model.OrderResponse;
import ru.yandex.direct.bsexport.model.UpdateData2Response;

import static java.util.stream.Collectors.toMap;
import static java.util.stream.Collectors.toSet;

@Component
public class BsResponseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BsResponseProcessor.class);

    public BsProcessedResponse process(List<Order> requestedOrders, UpdateData2Response updateData2Response) {

        var requestedCampaignsIds = requestedOrders.stream()
                .map(Order::getEID)
                .collect(toSet());
        var processedResponse = new BsProcessedResponse();

        if (updateData2Response.getUnDone()) {
            logger.error("UnDone received in bs response");
        }
        if (updateData2Response.getError()) {
            logger.error("Error received in bs response: {}", updateData2Response.getErrorMessage());
        }
        var campaignsIdsToOrderResponse = updateData2Response.getORDERMap().values().stream()
                .collect(toMap(OrderResponse::getEID, orderResponse -> orderResponse));

        for (var requestedCampaignsId : requestedCampaignsIds) {
            var unSuccessful = false;
            if (!campaignsIdsToOrderResponse.containsKey(requestedCampaignsId)) {
                processedResponse.addAbsentCampaign(requestedCampaignsId);
                continue;
            }
            var order = campaignsIdsToOrderResponse.get(requestedCampaignsId);
            if (order.getUnDone()) {
                logger.error("UnDone order with campaignId {}, OrderId {}", order.getEID(), order.getID());
                processedResponse.addUndoneCampaign(order.getEID());
                unSuccessful = true;
            }
            if (order.getError()) {
                logger.error("{}, campaignId {}, OrderId {}", order.getErrorMessage(), order.getEID(), order.getID());
                processedResponse.addErrorCampaign(order.getEID());
                unSuccessful = true;
            }
            if (!unSuccessful) {
                processedResponse.addProcessedCampaign(order.getEID());
            }
        }
        //TODO: DIRECT-120175: считать и отправлять в solomon метрики по обработке soap-ответа БК
        return processedResponse;
    }
}
