package ru.yandex.direct.bsexport.configuration;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;

import ru.yandex.direct.bsexport.logbroker.FeedMessagesLogbrokerWriterFactory;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;
import ru.yandex.kikimr.persqueue.auth.Credentials;

@Configuration
@Import({CoreConfiguration.class})
@ComponentScan(
        basePackages = "ru.yandex.direct.bsexport",
        excludeFilters = @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION)
)
@ParametersAreNonnullByDefault
public class BsExportConfiguration {
    public static final String BS_EXPORT_WORKER_LOGBROKER_CLIENT_FACTORY = "bs_export_worker_logboker_client_factory";

    @Bean(BS_EXPORT_WORKER_LOGBROKER_CLIENT_FACTORY)
    public LogbrokerClientFactoryFacade logbrokerClientFactoryFacade(TvmIntegration tvmIntegration,
                                                                     DirectConfig directConfig) {
        TvmService tvmService = TvmService.fromStringStrict(directConfig.getString("bs_export_worker.logbroker" +
                ".tvm_service_name"));
        Supplier<Credentials> credentialsSupplier = () -> {
            String serviceTicket = tvmIntegration.getTicket(tvmService);
            return Credentials.tvm(serviceTicket);
        };
        return new LogbrokerClientFactoryFacade(credentialsSupplier);
    }

    @Bean
    public FeedMessagesLogbrokerWriterFactory feedMessagesLogbrokerWriterFactory(
            @Qualifier(BS_EXPORT_WORKER_LOGBROKER_CLIENT_FACTORY) LogbrokerClientFactoryFacade logbrokerClientFactoryFacade,
            DirectConfig directConfig) {
        return new FeedMessagesLogbrokerWriterFactory(logbrokerClientFactoryFacade, directConfig);
    }
}
