package ru.yandex.direct.bsexport.exception;

public class BsExportProcessingException extends RuntimeException {
    private final long campaignId;
    private final long adGroupId;
    private final long bannerId;

    public BsExportProcessingException(String message, Throwable cause,
                                       long campaignId, long adGroupId, long bannerId) {
        super(message, cause);
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.bannerId = bannerId;
    }

    public BsExportProcessingException(String message, Throwable cause, long campaignId) {
        this(message, cause, campaignId, 0, 0);
    }

    public BsExportProcessingException(String message, long campaignId) {
        this(message, null, campaignId);
    }

    @Override
    public String getMessage() {
        return super.getMessage()
                + String.format(" (campaignId=%d adgroupId=%d bannerId=%d)", campaignId, adGroupId, bannerId);
    }

    public long getCampaignId() {
        return campaignId;
    }
}
