package ru.yandex.direct.bsexport.iteration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.bsexport.iteration.container.ExportCandidatesSelectionCriteria;
import ru.yandex.direct.bsexport.iteration.repository.CampaignsStatusBsSyncRepository;
import ru.yandex.direct.bsexport.iteration.repository.CandidatesRepository;
import ru.yandex.direct.core.entity.bs.export.queue.repository.BsExportQueueRepository;
import ru.yandex.direct.core.entity.bs.export.queue.repository.BsExportSpecialsRepository;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.walletparams.repository.WalletParamsRepository;

/**
 * Фабрика для {@link BsExportIterationContext}.
 * Кроме этого используется как package-private контейнер с репозиториями для *Step классов.
 */
@ParametersAreNonnullByDefault
@Service
public class BsExportIterationFactory {
    final BsExportQueueRepository bsExportQueueRepository;
    final BsExportSpecialsRepository bsExportSpecialsRepository;
    final CandidatesRepository candidatesRepository;
    final CampaignRepository campaignRepository;
    final WalletParamsRepository walletParamsRepository;
    final CampaignsStatusBsSyncRepository campaignsStatusBsSyncRepository;

    @Autowired
    public BsExportIterationFactory(
            BsExportQueueRepository bsExportQueueRepository,
            BsExportSpecialsRepository bsExportSpecialsRepository,
            CandidatesRepository candidatesRepository,
            CampaignRepository campaignRepository,
            WalletParamsRepository walletParamsRepository,
            CampaignsStatusBsSyncRepository campaignsStatusBsSyncRepository) {
        this.bsExportQueueRepository = bsExportQueueRepository;
        this.bsExportSpecialsRepository = bsExportSpecialsRepository;
        this.candidatesRepository = candidatesRepository;
        this.campaignRepository = campaignRepository;
        this.walletParamsRepository = walletParamsRepository;
        this.campaignsStatusBsSyncRepository = campaignsStatusBsSyncRepository;
    }

    /**
     * Выборка из очереди и блокировка кампаний для синхронизации с БК.
     * Возвращает контекст итерации экспорта.
     */
    public BsExportIterationContext lockCampaignsInQueue(ExportCandidatesSelectionCriteria selectionCriteria) {
        BsExportIterationContext iterationContext = new BsExportIterationContext(this, selectionCriteria);
        iterationContext.initialize();
        return iterationContext;
    }
}
