package ru.yandex.direct.bsexport.iteration;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.bs.export.model.WorkerType;
import ru.yandex.direct.core.entity.bs.export.queue.model.BsExportCandidateInfo;

@ParametersAreNonnullByDefault
class QueueTypeRemovingStep {
    private final WorkerType workerType;

    QueueTypeRemovingStep(BsExportIterationContext iterationContext) {
        this.workerType = iterationContext.selectionCriteria.getWorkerType();
    }

    boolean isApplicable(BsExportCandidateInfo candidateInfo) {
        return workerType.isTemporaryQueueType() && !workerType.getWorkerPurpose().isApplicable(candidateInfo);
    }

    List<Long> filter(Collection<BsExportCandidateInfo> exportCandidatesInfo) {
        return exportCandidatesInfo.stream()
                .filter(this::isApplicable)
                .map(BsExportCandidateInfo::getCampaignId)
                .collect(Collectors.toList());
    }
}
