package ru.yandex.direct.bsexport.iteration.container;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * Лимиты количество объектов, попадающих в один запрос.
 */
public class ExportBatchLimits {
    public static final ExportBatchLimits DEFAULT = new Builder().build();

    private final int campaignsLimit;
    private final int contextsLimit;
    private final int bannersLimit;
    private final int keywordsLimit;
    private final int pricesLimit;
    private final int dbRowsLimit;

    private ExportBatchLimits(Builder builder)
    {
        this.campaignsLimit = builder.campaignsLimit;
        this.contextsLimit = builder.contextsLimit;
        this.bannersLimit = builder.bannersLimit;
        this.keywordsLimit = builder.keywordsLimit;
        this.pricesLimit = builder.pricesLimit;
        this.dbRowsLimit = builder.dbRowsLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int campaignsLimit;
        private int contextsLimit;
        private int bannersLimit;
        private int keywordsLimit;
        private int pricesLimit;
        private int dbRowsLimit;

        /**
         * Значения по умолчанию из BS::Export
         */
        private Builder() {
            campaignsLimit = 500;
            contextsLimit = 300;
            bannersLimit = 1_500;
            keywordsLimit = 5_000;
            pricesLimit = 25_000;
            dbRowsLimit = 15_000;
        }

        public ExportBatchLimits build() {
            checkArgument(campaignsLimit > 0, "campaigns limit should be greater than 0");
            checkArgument(contextsLimit > 0, "contexts limit should be greater than 0");
            checkArgument(bannersLimit > 0, "banners limit should be greater than 0");
            checkArgument(keywordsLimit > 0, "keywords limit should be greater than 0");
            checkArgument(pricesLimit > 0, "prices limit should be greater than 0");
            checkArgument(dbRowsLimit > 0, "db rows limit should be greater than 0");

            return new ExportBatchLimits(this);
        }

        public Builder withCampaignsLimit(int campaignsLimit) {
            this.campaignsLimit = campaignsLimit;
            return this;
        }

        public Builder withContextsLimit(int contextsLimit) {
            this.contextsLimit = contextsLimit;
            return this;
        }

        public Builder withBannersLimit(int bannersLimit) {
            this.bannersLimit = bannersLimit;
            return this;
        }

        public Builder withKeywordsLimit(int keywordsLimit) {
            this.keywordsLimit = keywordsLimit;
            return this;
        }

        public Builder withPricesLimit(int pricesLimit) {
            this.pricesLimit = pricesLimit;
            return this;
        }

        public Builder withDbRowsLimit(int dbRowsLimit) {
            this.dbRowsLimit = dbRowsLimit;
            return this;
        }
    }

    public int getCampaignsLimit() {
        return campaignsLimit;
    }

    public int getContextsLimit() {
        return contextsLimit;
    }

    public int getBannersLimit() {
        return bannersLimit;
    }

    public int getKeywordsLimit() {
        return keywordsLimit;
    }

    public int getPricesLimit() {
        return pricesLimit;
    }

    public int getDbRowsLimit() {
        return dbRowsLimit;
    }
}
