package ru.yandex.direct.bsexport.iteration.repository;

import java.time.LocalDateTime;
import java.util.List;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusbssynced;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static org.jooq.impl.DSL.iif;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusbssynced.Sending;

@Repository
public class CampaignsStatusBsSyncRepository {
    private final DslContextProvider dslContextProvider;

    public CampaignsStatusBsSyncRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public void setSynced(int shard, List<Long> campaignsIds) {
        dslContextProvider.ppc(shard)
                .update(CAMPAIGNS)
                .set(CAMPAIGNS.STATUS_BS_SYNCED, iif(CAMPAIGNS.STATUS_BS_SYNCED.eq(Sending),
                        CampaignsStatusbssynced.Yes, CAMPAIGNS.STATUS_BS_SYNCED))
                .set(CAMPAIGNS.LAST_CHANGE, LocalDateTime.now())
                .where(CAMPAIGNS.CID.in(campaignsIds))
                .execute();
    }
}
