package ru.yandex.direct.bsexport.logbroker;

import java.time.Duration;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.entity.bs.export.model.WorkerType;
import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerProducerPropertiesImpl;
import ru.yandex.kikimr.persqueue.compression.CompressionCodec;


public class FeedMessagesLogbrokerWriterFactory {
    private final LogbrokerClientFactoryFacade logbrokerClientFactoryFacade;
    private final Properties properties;
    private static final String SOURCE_NAME_TEMPLATE = "%s-%s:%d";

    public FeedMessagesLogbrokerWriterFactory(LogbrokerClientFactoryFacade logbrokerClientFactoryFacade,
                                              DirectConfig directConfig) {
        this.logbrokerClientFactoryFacade = logbrokerClientFactoryFacade;
        var bsExportWorkerLogbrokerBranch = directConfig.getBranch("bs_export_worker.logbroker");
        this.properties = new Properties()
                .setWriteTopic(bsExportWorkerLogbrokerBranch.getString("topic"))
                .setRetries(bsExportWorkerLogbrokerBranch.getInt("retries"))
                .setHost(bsExportWorkerLogbrokerBranch.getString("host"))
                .setTimeout(bsExportWorkerLogbrokerBranch.getDuration("timeout"))
                .setObjectsInOneMessage(bsExportWorkerLogbrokerBranch.getInt("objects_in_one_message"))
                .setCompressionCodec(CompressionCodec.GZIP);
    }

    public FeedMessegesLogbrokerWriter getWriter(int shard, WorkerType workerType, long workerId) {
        var logbrokerProducerProperties = LogbrokerProducerPropertiesImpl.newBuilder()
                .setCompressionCodec(properties.compressionCodec)
                .setTimeoutSec(properties.timeout.getSeconds())
                .setHost(properties.host)
                .setWriteTopic(properties.writeTopic)
                .setRetries(properties.retries)
                .setGroup(shard)
                .build();
        var source = String.format(SOURCE_NAME_TEMPLATE, workerType.name(), workerId, shard);
        var producerSupplier = logbrokerClientFactoryFacade.createProducerSupplier(logbrokerProducerProperties,
                source);
        return new FeedMessegesLogbrokerWriter(producerSupplier, properties.timeout,
                properties.retries, properties.objectsInOneMessage);
    }

    private static class Properties {
        private String writeTopic;
        private String host;
        private Duration timeout;
        private int retries;
        private int objectsInOneMessage;
        private CompressionCodec compressionCodec;

        Properties setWriteTopic(String writeTopic) {
            this.writeTopic = writeTopic;
            return this;
        }

        Properties setHost(String host) {
            this.host = host;
            return this;
        }

        Properties setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Properties setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        Properties setCompressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        Properties setObjectsInOneMessage(int objectsInOneMessage) {
            this.objectsInOneMessage = objectsInOneMessage;
            return this;
        }
    }
}
