package ru.yandex.direct.bsexport.snapshot;

import java.math.BigDecimal;
import java.util.Set;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.client.model.ClientFlags;
import ru.yandex.direct.currency.Currencies;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbschema.ppc.enums.ClientCurrencyChangesCurrencyTo;
import ru.yandex.direct.dbschema.ppc.tables.Campaigns;
import ru.yandex.direct.jooqmapper.read.FieldValues;
import ru.yandex.direct.jooqmapper.read.ReaderFunction1;

import static ru.yandex.direct.core.entity.campaign.repository.CampaignRepository.WALLETS;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.utils.CommonUtils.nvl;

class BsExportMapping {
    static final ReaderFunction1<String, Set<ClientFlags>> CLIENT_FLAGS_FROM_DB =
            RepositoryUtils.enumSetReader(ClientFlags.class, ClientFlags::fromTypedValue);

    private BsExportMapping() {
    }

    /**
     * @see ru.yandex.direct.core.entity.campaign.repository.CampaignRepository#campaignBalance(Campaigns, Campaigns)
     */
    static boolean campaignBalanceIsPositive(FieldValues fields) {
        BigDecimal sum = fields.getValue(CAMPAIGNS.SUM);
        BigDecimal sumSpent = fields.getValue(CAMPAIGNS.SUM_SPENT);
        BigDecimal walletSum = fields.getValue(WALLETS.SUM);
        BigDecimal walletSumSpent = fields.getValue(WALLETS.SUM_SPENT);

        return sum
                .subtract(sumSpent)
                .add(nvl(walletSum, BigDecimal.ZERO))
                .subtract(nvl(walletSumSpent, BigDecimal.ZERO))
                .compareTo(Currencies.EPSILON) >= 0;
    }

    static CurrencyCode clientCurrencyChangeFromDb(ClientCurrencyChangesCurrencyTo clientCurrencyChangesCurrency) {
        if (clientCurrencyChangesCurrency == null) {
            return null;
        }
        return CurrencyCode.valueOf(clientCurrencyChangesCurrency.name());
    }

}
