package ru.yandex.direct.bsexport.snapshot;

import java.sql.Connection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.TransactionalRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.bsexport.iteration.BsExportIterationContext;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository;
import ru.yandex.direct.core.entity.internalads.repository.InternalAdsProductRepository;
import ru.yandex.direct.core.entity.product.repository.ProductRepository;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

@ParametersAreNonnullByDefault
@Service
public class SnapshotDataFactory {
    static final Logger logger = LoggerFactory.getLogger(SnapshotDataFactory.class);

    private final DslContextProvider dslContextProvider;

    final SnapshotRepository bsExportRepository;
    final CampaignTypedRepository campaignTypedRepository;
    final InternalAdsProductRepository internalAdsProductRepository;
    final ProductRepository productRepository;
    final RetargetingConditionRepository retargetingConditionRepository;
    final CryptaSegmentRepository cryptaSegmentRepository;

    @Autowired
    public SnapshotDataFactory(DslContextProvider dslContextProvider,
                               SnapshotRepository bsExportRepository,
                               CampaignTypedRepository campaignTypedRepository,
                               InternalAdsProductRepository internalAdsProductRepository,
                               ProductRepository productRepository,
                               RetargetingConditionRepository retargetingConditionRepository,
                               CryptaSegmentRepository cryptaSegmentRepository) {
        this.dslContextProvider = dslContextProvider;
        this.bsExportRepository = bsExportRepository;
        this.campaignTypedRepository = campaignTypedRepository;
        this.internalAdsProductRepository = internalAdsProductRepository;
        this.productRepository = productRepository;
        this.retargetingConditionRepository = retargetingConditionRepository;
        this.cryptaSegmentRepository = cryptaSegmentRepository;
    }

    public BsExportSnapshot getSnapshot(BsExportIterationContext iterationContext) {
        BsExportSnapshot snapshot = new BsExportSnapshot(this, iterationContext);

        TransactionalRunnable repeatableReadOperation = conf -> {
            DSLContext dsl = conf.dsl();
            dsl.connection(connection -> connection.setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ));
            snapshot.getFirstPassFetchers().forEach(fetcher -> fetcher.firstFetch(dsl));
        };
        dslContextProvider.ppcTransaction(iterationContext.getShard(), repeatableReadOperation);

        return snapshot;
    }
}
