package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Objects;

import ru.yandex.direct.core.entity.product.model.ProductType;

public class BillingAggregateRequest {
    private final Long walletId;
    private final ProductType productType;

    public BillingAggregateRequest(Long walletId, ProductType productType) {
        this.walletId = walletId;
        this.productType = productType;
    }

    public Long getWalletId() {
        return walletId;
    }

    public ProductType getProductType() {
        return productType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BillingAggregateRequest that = (BillingAggregateRequest) o;
        return Objects.equals(walletId, that.walletId) &&
                productType == that.productType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(walletId, productType);
    }
}
