package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.bsexport.snapshot.internal.HolderBase;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandSafety;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.retargeting.model.GoalBase;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository;

@ParametersAreNonnullByDefault
public class BrandsafetyRetargetingConditionsHolder extends HolderBase<CommonCampaign, Long, RetargetingCondition> {
    private final RetargetingConditionRepository retargetingConditionRepository;
    private List<Long> goalsIds;

    public BrandsafetyRetargetingConditionsHolder(
            RetargetingConditionRepository retargetingConditionRepository,
            Supplier<Collection<CommonCampaign>> idsSupplier) {
        super(idsSupplier);
        this.retargetingConditionRepository = retargetingConditionRepository;
    }

    @Override
    protected void firstFetchInternal(DSLContext dslContext, Collection<CommonCampaign> campaignsToFetch) {
        var brandSafetytRetCond = campaignsToFetch.stream()
                .filter(campaign -> campaign instanceof CampaignWithBrandSafety)
                .map(campaign -> (CampaignWithBrandSafety) campaign)
                .map(CampaignWithBrandSafety::getBrandSafetyRetCondId)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        var conditions = retargetingConditionRepository.getConditions(dslContext, brandSafetytRetCond);
        conditions
                .forEach(condition -> put(condition.getId(), condition));
        goalsIds = conditions.stream()
                .flatMap(condition -> condition.getRules().stream())
                .flatMap(rule -> rule.getGoals().stream())
                .map(GoalBase::getId)
                .collect(Collectors.toList());
    }

    public Collection<Long> getGoalIds() {
        checkInitialized();
        return goalsIds;
    }
}
