package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.bsexport.exception.BsExportProcessingException;
import ru.yandex.direct.bsexport.snapshot.internal.HolderBase;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;

@ParametersAreNonnullByDefault
public class CampaignsHolder extends HolderBase<Long, Long, CommonCampaign> {

    private final CampaignTypedRepository campaignTypedRepository;

    public CampaignsHolder(CampaignTypedRepository campaignTypedRepository,
                           Supplier<Collection<Long>> campaignIdsSupplier) {
        super(campaignIdsSupplier);
        this.campaignTypedRepository = campaignTypedRepository;
    }

    @Override
    protected void firstFetchInternal(DSLContext dslContext, Collection<Long> campaignIds) {
        assert campaignTypedRepository != null;
        campaignTypedRepository.getTypedCampaigns(dslContext, campaignIds).forEach(this::addCampaignWithCheck);
    }

    public Collection<Long> getUserIds() {
        return getData().values()
                .stream()
                .map(CommonCampaign::getUid)
                .collect(Collectors.toSet());
    }

    public Collection<Long> getClientIds() {
        return getData().values()
                .stream()
                .map(CommonCampaign::getClientId)
                .collect(Collectors.toSet());
    }

    public Collection<CommonCampaign> getCampaigns() {
        return getData().values();
    }

    private void addCampaignWithCheck(BaseCampaign baseCampaign) {
        Long campaignId = baseCampaign.getId();
        try {
            put(campaignId, (CommonCampaign) baseCampaign);
        } catch (ClassCastException e) {
            throw new BsExportProcessingException("Campaign is not extending CommonCampaign", e, campaignId);
        }
    }
}
