package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.bsexport.snapshot.SnapshotRepository;
import ru.yandex.direct.bsexport.snapshot.internal.HolderBase;
import ru.yandex.direct.bsexport.snapshot.model.ExportedClient;

@ParametersAreNonnullByDefault
public class ClientsHolder extends HolderBase<Long, Long, ExportedClient> {
    private final SnapshotRepository bsExportRepository;

    public ClientsHolder(SnapshotRepository bsExportRepository, Supplier<Collection<Long>> clientIdsSupplier) {
        super(clientIdsSupplier);
        this.bsExportRepository = bsExportRepository;
    }

    @Override
    protected void firstFetchInternal(DSLContext dslContext, Collection<Long> clientIds) {
        Map<Long, ExportedClient> clientInfo = bsExportRepository.getClients(dslContext, clientIds);
        putAll(clientInfo);
    }

    public Collection<Long> getClientIds() {
        return getData().keySet();
    }
}
