package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Collection;
import java.util.function.Supplier;

import org.jooq.DSLContext;

import ru.yandex.direct.bsexport.snapshot.internal.HolderBase;
import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository;
import ru.yandex.direct.core.entity.retargeting.model.Goal;

public class CryptaGoalsHolder extends HolderBase<Long, Long, Goal> {
    private final CryptaSegmentRepository cryptaSegmentRepository;

    public CryptaGoalsHolder(CryptaSegmentRepository cryptaSegmentRepository, Supplier<Collection<Long>> idsSupplier) {
        super(idsSupplier);
        this.cryptaSegmentRepository = cryptaSegmentRepository;
    }

    @Override
    protected void firstFetchInternal(DSLContext dslContext, Collection<Long> goalIds) {
        putAll(cryptaSegmentRepository.getByIds(goalIds));
    }
}
