package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Collection;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.bsexport.snapshot.internal.HolderBase;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.core.entity.internalads.model.InternalAdsProduct;
import ru.yandex.direct.core.entity.internalads.repository.InternalAdsProductRepository;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toMap;

@ParametersAreNonnullByDefault
public class InternalAdsProductsHolder extends HolderBase<CommonCampaign, Long, InternalAdsProduct> {

    private final InternalAdsProductRepository internalAdsProductRepository;

    public InternalAdsProductsHolder(InternalAdsProductRepository internalAdsProductRepository,
                                     Supplier<Collection<CommonCampaign>> idsSupplier) {
        super(idsSupplier);
        this.internalAdsProductRepository = internalAdsProductRepository;
    }

    @Override
    protected void firstFetchInternal(DSLContext dslContext, Collection<CommonCampaign> campaignsToFetch) {
        var internalCampaignsClientIds = campaignsToFetch.stream()
                .filter(camp -> camp instanceof InternalCampaign)
                .map(CommonCampaign::getClientId)
                .collect(toList());
        if (internalCampaignsClientIds.isEmpty()) {
            return;
        }
        var internalAdsProductsMap = internalAdsProductRepository.getProductsNotStrictly(dslContext,
                internalCampaignsClientIds)
                .stream()
                .collect(toMap(
                        internalAdsProduct -> internalAdsProduct.getClientId().asLong(),
                        internalAdsProduct -> internalAdsProduct));
        putAll(internalAdsProductsMap);
    }
}

