package ru.yandex.direct.bsexport.snapshot.holders;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.bsexport.snapshot.SnapshotRepository;
import ru.yandex.direct.bsexport.snapshot.internal.HolderBase;
import ru.yandex.direct.bsexport.snapshot.model.ExportedUser;

@ParametersAreNonnullByDefault
public class UsersHolder extends HolderBase<Long, Long, ExportedUser> {

    private final SnapshotRepository bsExportRepository;

    public UsersHolder(SnapshotRepository bsExportRepository, Supplier<Collection<Long>> userIdsSupplier) {
        super(userIdsSupplier);
        this.bsExportRepository = bsExportRepository;
    }

    @Override
    protected void firstFetchInternal(DSLContext dslContext, Collection<Long> userIds) {
        Map<Long, ExportedUser> userInfo = bsExportRepository.getUsers(dslContext, userIds);
        putAll(userInfo);
    }
}
