package ru.yandex.direct.canvas.model;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Результаты операции над списком креативов
 * Велосипед, единообразия для правильнее было бы использовать Errors, но тут это кажется overkill
 * плюс с десериализованным errors будет сложнее работать на стороне клиента, в то время как
 * возможности Errors не нужны
 */
public class OnCreativeOperationResult {
    @JsonProperty("status")
    private OnCreativeOperationResultStatus status;

    @JsonProperty("errors")
    private List<String> errors;

    public OnCreativeOperationResult() { // need for json deserialization
    }

    public OnCreativeOperationResult(OnCreativeOperationResultStatus status,
                                     @Nullable List<String> errors) {
        this.status = status;
        this.errors = errors;
    }

    public static OnCreativeOperationResult ok() {
        return new OnCreativeOperationResult(OnCreativeOperationResultStatus.OK, null);
    }

    public static OnCreativeOperationResult error(String error) {
        return errors(Collections.singletonList(error));
    }

    public static OnCreativeOperationResult errors(List<String> errors) {
        return new OnCreativeOperationResult(OnCreativeOperationResultStatus.ERROR, errors);
    }

    public OnCreativeOperationResultStatus getStatus() {
        return status;
    }

    public List<String> getErrors() {
        return errors;
    }

}
