package ru.yandex.direct.cloud.iam.service;

import ru.yandex.direct.cloud.iam.IIamTokenProvider;

/**
 * Класс с пустой реализацией поставщика cloud iam-токенов. Нужен для использования в средах, где поднимать настоящего
 * поставщика cloud iam-токенов не нужно, например в сендбоксе для выполнения юнит-тестов
 */
public class DummyIamTokenProvider implements IIamTokenProvider {
    private final String errorOnGetToken;
    private final Exception inner;

    public DummyIamTokenProvider(String errorOnGetToken, Exception inner) {
        this.errorOnGetToken = errorOnGetToken;
        this.inner = inner;
    }

    public DummyIamTokenProvider(String errorOnGetToken) {
        this(errorOnGetToken, null);
    }

    @Override
    public String getCurrentIamToken() {
        if (errorOnGetToken != null) {
            throw new IllegalArgumentException(errorOnGetToken, inner);
        }
        return null;
    }

    @Override
    public void invalidateCurrentIamToken() {

    }
}
