package ru.yandex.direct.codegen.core.entity.banner;

public class BannerDataCollector implements DataCollector<AbstractBannerPartModel> {

    private final Console console;

    private final OneToOneFlatBannerDataCollector oneToOneFlatBannerDataCollector;

    public BannerDataCollector() {
        this.console = new Console();
        this.oneToOneFlatBannerDataCollector = new OneToOneFlatBannerDataCollector();
    }

    @Override
    public AbstractBannerPartModel collectData() {
        RelationType relationType = getRelationType();
        WrapType wrapType = getWrapType();

        if (relationType == RelationType.ONE_TO_ONE) {
            if (wrapType == WrapType.NO_WRAP) {
                return oneToOneFlatBannerDataCollector.collectData();
            }
        }

        console.println("К сожалению на данный момент не поддержана генерация кода для новых частей такого типа");
        throw new UnsupportedOperationException();
    }

    private RelationType getRelationType() {
        console.printDelimiter();
        console.println("Какой тип отношения будет между баннером и новой его частью?");
        console.println("0: один-к-одному (примеры: турболендинг, креатив)");
        console.println("1: один-ко-многим (примеры: коллауты, пиксели)");
        console.print("Введите индекс: ");
        int relationTypeChoice = console.readInt();
        return RelationType.values()[relationTypeChoice];
    }

    private WrapType getWrapType() {
        console.printDelimiter();
        console.println("Будут ли поля новой части баннера находиться непосредственно в баннере");
        console.println("или же будут внутри промежуточного контейнера?");
        console.println("0: непосредственно в баннере (примеры: турболендинг, коллауты, пиксели)");
        console.println("1: в промежуточном контейнере (примеры: цена (bannerprice), измерители");
        console.print("Введите индекс: ");
        int wrapTypeChoice = console.readInt();
        return WrapType.values()[wrapTypeChoice];
    }

    private enum RelationType {
        ONE_TO_ONE,
        ONE_TO_MANY
    }

    private enum WrapType {
        NO_WRAP,
        CONTAINER
    }
}
