package ru.yandex.direct.codegen.core.entity.banner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import org.apache.commons.io.FileUtils;

public class BannerPartGen {

    private static final String PROJECT_ROOT = "/Users/aleran/arc/arcadia/direct/";
    private static final String BANNERS_ROOT =
            PROJECT_ROOT + "core/src/main/java/ru/yandex/direct/core/entity/bannernew/type/";

    private final Configuration cfg;
    private final BannerDataCollector bannerDataCollector;

    public BannerPartGen() throws Exception {
        cfg = initConfiguration();
        bannerDataCollector = new BannerDataCollector();
    }

    public static void main(String[] args) throws Exception {
        new BannerPartGen().run();
    }

    private Configuration initConfiguration() throws Exception {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
        cfg.setDirectoryForTemplateLoading(
                new File("/Users/aleran/arc/arcadia/direct/" +
                        "libs-internal/code-generator/src/main/resources/"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        return cfg;
    }

    private void run() throws Exception {
        AbstractBannerPartModel bannerPartModel = bannerDataCollector.collectData();
        generateCode(bannerPartModel);
    }

    private void generateCode(AbstractBannerPartModel bannerPartModel) throws Exception {
        File newPackageDir = new File(BANNERS_ROOT, bannerPartModel.getPackageName());
        mkDir(newPackageDir);

        generateRepo(bannerPartModel, newPackageDir);
        generateAddValidationSupport(bannerPartModel, newPackageDir);
        generateUpdateValidationSupport(bannerPartModel, newPackageDir);
        generateValidatorProvider(bannerPartModel, newPackageDir);
        generateValidators(bannerPartModel, newPackageDir);
        generateAddOperationSupport(bannerPartModel, newPackageDir);
        generateUpdateOperationSupport(bannerPartModel, newPackageDir);
    }

    private void generateRepo(AbstractBannerPartModel bannerPartModel, File newPackageDir) throws Exception {
        generateFile(bannerPartModel, newPackageDir,
                bannerPartModel.getInterfaceName() + "RepositoryTypeSupport.java",
                "one-to-one_flat_banner_repo_support.ftlh");
    }

    private void generateAddValidationSupport(
            AbstractBannerPartModel bannerPartModel,
            File newPackageDir) throws Exception {
        generateFile(bannerPartModel, newPackageDir,
                bannerPartModel.getInterfaceName() + "AddValidationTypeSupport.java",
                "add_validation_support.ftlh");
    }

    private void generateUpdateValidationSupport(
            AbstractBannerPartModel bannerPartModel,
            File newPackageDir) throws Exception {
        generateFile(bannerPartModel, newPackageDir,
                bannerPartModel.getInterfaceName() + "UpdateValidationTypeSupport.java",
                "update_validation_support.ftlh");
    }

    private void generateValidatorProvider(
            AbstractBannerPartModel bannerPartModel,
            File newPackageDir) throws Exception {
        generateFile(bannerPartModel, newPackageDir,
                bannerPartModel.getInterfaceName() + "ValidatorProvider.java",
                "validator_provider.ftlh");
    }

    private void generateValidators(
            AbstractBannerPartModel bannerPartModel,
            File newPackageDir) throws Exception {
        for (ModelPropInfo clientProp : bannerPartModel.getClientProps()) {
            ModelPropWithInterfaceInfo propWithInterface =
                    new ModelPropWithInterfaceInfo(clientProp, bannerPartModel);
            generateFile(propWithInterface,
                    newPackageDir,
                    clientProp.getUpperCamel() + "Validator.java",
                    "validator.ftlh");
        }
    }

    private void generateAddOperationSupport(
            AbstractBannerPartModel bannerPartModel,
            File newPackageDir) throws Exception {
        generateFile(bannerPartModel, newPackageDir,
                bannerPartModel.getInterfaceName() + "AddOperationTypeSupport.java",
                "add_support.ftlh");
    }

    private void generateUpdateOperationSupport(
            AbstractBannerPartModel bannerPartModel,
            File newPackageDir) throws Exception {
        generateFile(bannerPartModel, newPackageDir,
                bannerPartModel.getInterfaceName() + "UpdateOperationTypeSupport.java",
                "update_support.ftlh");
    }

    private void generateFile(Object dataModel, File newPackageDir,
                              String fileName, String templateName) throws Exception {
        File supportFile = new File(newPackageDir, fileName);
        Writer out = new OutputStreamWriter(new FileOutputStream(supportFile));

        Template repoTemplate = cfg.getTemplate(templateName);
        repoTemplate.process(dataModel, out);
    }

    private void mkDir(File dir) throws IOException {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            } else {
                throw new IllegalArgumentException("Не является директорией: " + dir.getAbsolutePath());
            }
        }
        FileUtils.forceMkdir(dir);
    }
}
