package ru.yandex.direct.codegen.core.entity.banner;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Console {

    private final BufferedReader reader;

    public Console() {
        this.reader = new BufferedReader(new InputStreamReader(System.in));
    }

    public void print(String str) {
        System.out.print(str);
    }

    public void println() {
        System.out.println();
    }

    public void printDelimiter() {
        println();
        println("-----------------------------------------------------------------");
        println();
    }

    public void println(String str) {
        System.out.println(str);
    }

    public void println(String str, Object... args) {
        System.out.println(String.format(str, args));
    }

    public String read() {
        try {
            return reader.readLine();
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Integer readInt() {
        return Integer.valueOf(read());
    }
}
