package ru.yandex.direct.codegen.core.entity.banner;

import java.util.Objects;

public class DbFieldInfo {

    private final Class type;
    private final String typeShort;
    private final String sourceName;
    private final String jooqUpperUnderscore;
//    private final String lowerCaseName;
//    private final String lowerCamelName;
//    private final String upperCamelName;

    public DbFieldInfo(Class type, String sourceName, String jooqUpperUnderscore) {
        this.type = type;
        this.typeShort = type.getName();
        this.sourceName = sourceName;
        this.jooqUpperUnderscore = jooqUpperUnderscore;
//        this.lowerCaseName = jooqUpperUnderscore.toLowerCase();
//        this.lowerCamelName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, jooqUpperUnderscore);
//        this.upperCamelName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, jooqUpperUnderscore);
    }

    public Class getType() {
        return type;
    }

    public String getTypeShort() {
        return typeShort;
    }

    public String getSourceName() {
        return sourceName;
    }

    public String getJooqUpperUnderscore() {
        return jooqUpperUnderscore;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DbFieldInfo that = (DbFieldInfo) o;
        return type.equals(that.type) &&
                typeShort.equals(that.typeShort) &&
                sourceName.equals(that.sourceName) &&
                jooqUpperUnderscore.equals(that.jooqUpperUnderscore);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, typeShort, sourceName, jooqUpperUnderscore);
    }
}
