package ru.yandex.direct.codegen.core.entity.banner;

import java.util.Objects;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.TypeName;

public class ModelPropInfo {

    private final String modelClassNameShort;
    private final TypeName typeName;
    private final boolean isAutogeneratedEnum;
    private final String typeShort;
    private final String lowerCamel;
    private final String upperCamel;
    private final String upperUnderscore;
    private final String getter;

    public ModelPropInfo(String modelClassNameShort,
                         TypeName typeName,
                         boolean isAutogeneratedEnum,
                         String lowerCamel) {
        this.modelClassNameShort = modelClassNameShort;
        this.typeName = typeName;
        this.isAutogeneratedEnum = isAutogeneratedEnum;
        this.typeShort = typeName.toString().substring(typeName.toString().lastIndexOf(".") + 1);
        this.lowerCamel = lowerCamel;
        this.upperCamel = lowerCamelToUpperCamel(lowerCamel);
        this.upperUnderscore = lowerCamelToUpperUnderscore(lowerCamel);
        this.getter = propToGetter(lowerCamel);
    }

    public String getModelClassNameShort() {
        return modelClassNameShort;
    }

    public TypeName getTypeName() {
        return typeName;
    }

    public boolean isAutogeneratedEnum() {
        return isAutogeneratedEnum;
    }

    public String getTypeShort() {
        return typeShort;
    }

    public String getLowerCamel() {
        return lowerCamel;
    }

    public String getUpperCamel() {
        return upperCamel;
    }

    public String getUpperUnderscore() {
        return upperUnderscore;
    }

    public String getGetter() {
        return getter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ModelPropInfo that = (ModelPropInfo) o;
        return isAutogeneratedEnum == that.isAutogeneratedEnum &&
                modelClassNameShort.equals(that.modelClassNameShort) &&
                typeName.equals(that.typeName) &&
                typeShort.equals(that.typeShort) &&
                lowerCamel.equals(that.lowerCamel) &&
                upperCamel.equals(that.upperCamel) &&
                upperUnderscore.equals(that.upperUnderscore) &&
                getter.equals(that.getter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(modelClassNameShort, typeName, isAutogeneratedEnum, typeShort, lowerCamel, upperCamel, upperUnderscore, getter);
    }

    private String lowerCamelToUpperUnderscore(String str) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, str);
    }

    private String lowerCamelToUpperCamel(String str) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, str);
    }

    private String propToGetter(String prop) {
        return "get" + lowerCamelToUpperCamel(prop);
    }
}
