package ru.yandex.direct.codegen.core.entity.banner;

public class ModelPropWithDbFieldInfo {

    private final ModelPropInfo prop;
    private final DbFieldInfo field;
    private final boolean read;
    private final boolean write;
    private final ModelPropWithDbFieldConverter converterToDb;
    private final ModelPropWithDbFieldConverter converterFromDb;

    public ModelPropWithDbFieldInfo(ModelPropInfo prop,
                                    DbFieldInfo field,
                                    boolean read,
                                    boolean write,
                                    ModelPropWithDbFieldConverter converterToDb,
                                    ModelPropWithDbFieldConverter converterFromDb) {
        this.prop = prop;
        this.field = field;
        this.read = read;
        this.write = write;
        this.converterToDb = converterToDb;
        this.converterFromDb = converterFromDb;
    }

    public ModelPropInfo getProp() {
        return prop;
    }

    public DbFieldInfo getField() {
        return field;
    }

    public boolean isRead() {
        return read;
    }

    public boolean isWrite() {
        return write;
    }

    public ModelPropWithDbFieldConverter getConverterToDb() {
        return converterToDb;
    }

    public ModelPropWithDbFieldConverter getConverterFromDb() {
        return converterFromDb;
    }
}
