package ru.yandex.direct.codegen.core.entity.banner;

import com.google.common.base.CaseFormat;

public class TableInfo {

    private final String sourceName;
    private final String jooqUpperCamel;
    private final String jooqClassNameFull;
    private final String jooqUpperUnderscore;
    private final String jooqRecordUpperCamel;

    public TableInfo(String sourceName) {
        this.sourceName = sourceName;
        this.jooqUpperCamel = tableToJooqUpperCamel(sourceName);
        this.jooqClassNameFull = tableToJooqClassNameFull(sourceName);
        this.jooqUpperUnderscore = tableToJooqUpperUnderscore(sourceName);
        this.jooqRecordUpperCamel = tableToJooqRecordUpperCamel(sourceName);
    }

    public String getSourceName() {
        return sourceName;
    }

    public String getJooqUpperCamel() {
        return jooqUpperCamel;
    }

    public String getJooqClassNameFull() {
        return jooqClassNameFull;
    }

    public String getJooqUpperUnderscore() {
        return jooqUpperUnderscore;
    }

    public String getJooqRecordUpperCamel() {
        return jooqRecordUpperCamel;
    }

    private String tableToJooqUpperCamel(String table) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table);
    }

    private String tableToJooqClassNameFull(String table) {
        return "ru.yandex.direct.dbschema.ppc.tables." + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table);
    }

    private String tableToJooqUpperUnderscore(String table) {
        return table.toUpperCase();
    }

    private String tableToJooqRecordUpperCamel(String table) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, table) + "Record";
    }
}
