package ru.yandex.direct.config;

import com.typesafe.config.ConfigException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.env.PropertySource;

/**
 * Adapter for using DirectConfig within Spring
 */
public class DirectConfigPropertySource extends PropertySource<DirectConfig> {
    public DirectConfigPropertySource(String name, DirectConfig source) {
        super(name, source);
    }

    @Override
    public Object getProperty(String name) {
        try {
            if ("server".equals(name)) { // тут возвращаетя объект. Спрашивает сам SpringBoot, поэтому такой костыль
                return this.getSource().findObject(name).orElse(null);
            } else {
                return this.getSource().findString(name).orElse(null);
            }
        } catch (ConfigException.BadPath ex) {
            // spring присылает сначала ключ как есть (с потенциальным дефолтом, типа "my.key:123")
            // в этом случае будет исключение, но это нормально
            logger.trace("", ex);
            return null;
        } catch (Exception e) {
            // Если случилось какое-то непредвиденное исключение, нужно обернуть его во что-то extends BeansException
            // чтобы спринг смог понять, что при конструировании бина произошла ошибка и что нужно позакрывать
            // уже проинициализированные бины
            throw new ApplicationContextException("Unhandled exception when trying to retrieve property " + name, e);
        }
    }
}
