package ru.yandex.direct.env;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.SystemUtils;

import static ru.yandex.direct.utils.SystemUtils.hostname;

public class DevEnvironment {
    private static final Pattern BETA_PORT_PATTERN = Pattern.compile("/www/[^/]+\\.(\\d+)/");
    private static final String DEVELOPER_HOST_PREFIX = "ppcdev";

    private DevEnvironment() {
        // utility class
    }

    /**
     * Нехитрая логика для определения, запускаемся мы на сервере, или на разработческом ноуте
     */
    public static boolean isDeveloperLaptop() {
        return SystemUtils.IS_OS_MAC
                || SystemUtils.IS_OS_WINDOWS
                || System.getenv("DISPLAY") != null
                || Files.notExists(Paths.get(EnvironmentTypeReader.FILE_NAME));
    }

    public static boolean isDeveloperHost(String hostname) {
        return hostname.startsWith(DEVELOPER_HOST_PREFIX);
    }

    /**
     * вычисление имени хоста для всяких логов и графитов
     * - для продакшен/тестовых хостов - hostname
     * - для ноутбуков - laptop-LOGIN
     * - для ppcdev-ов - PORT.ppcdevN.yandex.ru
     */
    public static String smartHostname() {
        if (isDeveloperLaptop()) {
            return "laptop-" + SystemUtils.USER_NAME;
        } else {
            String hostname = hostname();
            if (isDeveloperHost(hostname)) {
                OptionalInt port = betaPort();
                if (port.isPresent()) {
                    hostname = String.valueOf(port.getAsInt()) + "." + hostname;
                }
            }
            return hostname;
        }
    }

    /**
     * Определение порта беты (имеет смысл только для ppcdev*)
     */
    public static OptionalInt betaPort() {
        for (String cp : SystemUtils.JAVA_CLASS_PATH.split(":")) {
            String absolutePath = new File(cp).getAbsolutePath();
            Matcher matcher = BETA_PORT_PATTERN.matcher(absolutePath);
            if (matcher.find()) {
                return OptionalInt.of(Integer.parseInt(matcher.group(1)));
            }
        }
        return OptionalInt.empty();
    }
}
