package ru.yandex.direct.env;

import javax.annotation.Nonnull;

/**
 * Определение типа окружения
 */
public class Environment {
    private static final Object CURRENT_MONITOR = new Object();
    private static volatile EnvironmentType current;

    private Environment() {
    }

    /**
     * Прочитать тип окружения из переменной окружения, проперти или файла,
     * значение читается каждый раз
     */
    @Nonnull
    public static EnvironmentType get() {
        return EnvironmentTypeReader.read();
    }

    /**
     * Аналог get() с кешированием
     */
    @Nonnull
    public static EnvironmentType getCached() {
        EnvironmentType result = current;
        if (result == null) {
            synchronized (CURRENT_MONITOR) {
                if (current == null) {
                    current = get();
                }
                result = current;
            }
        }
        return result;
    }

    static void clearCache() {
        synchronized (CURRENT_MONITOR) {
            current = null;
        }
    }
}
