package ru.yandex.direct.env;

import java.util.EnumSet;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.utils.Condition;

/**
 * Базовый класс для создания условий на {@link EnvironmentType}, определяемый с помощью {@link EnvironmentTypeProvider}
 * Принимает в конструкторе список разрешенных типов окружений, для которых {@link Condition#evaluate()}
 * возвратит {@code true}
 *
 * @see Condition
 */
@ParametersAreNonnullByDefault
public abstract class EnvironmentCondition implements Condition {
    private EnvironmentTypeProvider environmentTypeProvider;
    private EnumSet<EnvironmentType> allowedEnv;

    /**
     * @param environmentTypeProvider интерфейс для определения текущего типа окружения
     * @param allowedFirst            разрешенный тип окружения
     * @param allowedOther            другие разрешенные типы окружения, опционально
     */
    public EnvironmentCondition(EnvironmentTypeProvider environmentTypeProvider, EnvironmentType allowedFirst,
                                EnvironmentType... allowedOther) {
        this.environmentTypeProvider = environmentTypeProvider;
        this.allowedEnv = EnumSet.of(allowedFirst, allowedOther);
    }

    /**
     * Проверяет, входит ли текущий тип окружения в заданный (через конструктор) список.
     */
    @Override
    public final boolean evaluate() {
        return allowedEnv.contains(environmentTypeProvider.get());
    }
}
