package ru.yandex.direct.env;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static ru.yandex.direct.env.EnvironmentType.PRODUCTION;
import static ru.yandex.direct.env.EnvironmentType.TESTING;

/**
 * Условие "production или тестовое окружение" (test + prod).
 * Без песочниц, DB_TESTING, dev*.
 */
@Component
public class NonDevelopmentEnvironment extends EnvironmentCondition {
    @Autowired
    public NonDevelopmentEnvironment(EnvironmentTypeProvider environmentTypeProvider) {
        super(environmentTypeProvider, PRODUCTION, TESTING);
    }
}
