package ru.yandex.direct.env;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static ru.yandex.direct.env.EnvironmentType.DEV7;
import static ru.yandex.direct.env.EnvironmentType.DEVELOPMENT;
import static ru.yandex.direct.env.EnvironmentType.DEVTEST;
import static ru.yandex.direct.env.EnvironmentType.TESTING;

/**
 * Условие "разработческое и тестовое окружение" (тест + дев).
 * Без песочниц и DB_TESTING.
 */
@Component
public class NonProductionEnvironment extends EnvironmentCondition {
    @Autowired
    public NonProductionEnvironment(EnvironmentTypeProvider environmentTypeProvider) {
        super(environmentTypeProvider, TESTING, DEVTEST, DEV7, DEVELOPMENT);
    }
}
