package ru.yandex.direct.env;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static ru.yandex.direct.env.EnvironmentType.DEV7;
import static ru.yandex.direct.env.EnvironmentType.DEVELOPMENT;
import static ru.yandex.direct.env.EnvironmentType.DEVTEST;
import static ru.yandex.direct.env.EnvironmentType.PRODUCTION;
import static ru.yandex.direct.env.EnvironmentType.TESTING;

/**
 * Условие "обычное окружение" (продакшн + тест + дев).
 * <p>
 * НЕ включены:
 * <ul>
 * <li>песочницы (и не должны быть)</li>
 * <li>{@link ru.yandex.direct.env.EnvironmentType#TESTING2} - сейчас нет второй java-ТС</li>
 * <li>{@link ru.yandex.direct.env.EnvironmentType#DB_TESTING} - не предназначена для запуска приложений вцелом</li>
 * </ul>
 */
@Component
public class TypicalEnvironment extends EnvironmentCondition {
    @Autowired
    public TypicalEnvironment(EnvironmentTypeProvider environmentTypeProvider) {
        super(environmentTypeProvider, PRODUCTION, TESTING, DEVTEST, DEV7, DEVELOPMENT);
    }
}
