package ru.yandex.direct.env;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static ru.yandex.direct.env.EnvironmentType.DEVELOPMENT;
import static ru.yandex.direct.env.EnvironmentType.DEVTEST;
import static ru.yandex.direct.env.EnvironmentType.PRODUCTION;
import static ru.yandex.direct.env.EnvironmentType.TESTING;

/**
 * Условие "обычное окружение" (продакшн + тест + дев) без dev7.
 */
@Component
public class TypicalEnvironmentNoDev7 extends EnvironmentCondition {
    @Autowired
    public TypicalEnvironmentNoDev7(EnvironmentTypeProvider environmentTypeProvider) {
        super(environmentTypeProvider, PRODUCTION, TESTING, DEVTEST, DEVELOPMENT);
    }
}
